require( "HiddenObject/script/style.lua" );

HeaderFont = {
  standardFont,
  32,
  Color(131, 167, 184, 255)
};

TextFont = {
  standardFont,
  28,
  WhiteColor
};

ButtonFont = {
  standardFont,
  24,
  Color(131, 167, 184, 255)
};


FooterGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover",
};	

FooterStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	font = StandardButtonFont,
};
CheckBoxButtonFont = {
  standardFont,
  18,
  Color(204, 198, 183, 255)
};


DialogTitleText = 
{
	parent=DefaultStyle,
	font = HeaderFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=16,y=12,w=kMax,h=30
};

DialogBodyText =
 {
	parent=DefaultStyle,
	font =TextFont,
	flags = kVAlignCenter + kHAlignCenter,
	x=0,y=46,w=kMax,h=kMax-60
};

OkGraphics = {
	"HiddenObject/UI/Button/oknormal.png",
	"HiddenObject/UI/Button/okdown.png",
	"HiddenObject/UI/Button/okover.png",
};	

OkStyle= {
	type = kPush,
	font = ButtonFont,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = OkGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};
MakeDialog
{
	name="SaveInfoDialog", -- Remember, this is like saying table['name']=name, so it works.
    Bitmap
    {
		image="HiddenObject/UI/Background/dialog",
		x=kCenter,
		y=kCenter - 44,
		
		SetStyle(DialogTitleText),
		Text
		{
			flags = kVAlignCenter + kHAlignCenter,
			name = "title",
			label= gDialogTable.title,
			font = HeaderFont,
			x = kCenter,
			y = 20,
			h = 36,
		};		
		SetStyle(DialogBodyText),
		Text
		{
			flags = kVAlignCenter + kHAlignCenter,
			name = "saveinfo",
			label= gDialogTable.body,
			x = kCenter,
			y = 30,
		};
		
        
        --SetStyle(RightCurveStyle),
        SetStyle(FooterStyle),
        Button
        {
			command=
				function() 
                end;
            flags = 5,
            close = true,
            label = "yes",
            name = "yes",
            x = kCenter-80,
            y = -80
        },
         Button
        {
			command=
				function() 
                end;
            flags = 5,
            close = true,
            label = "no",
            name = "no",
            x = kCenter+80,
            y = -80
        },       
        
        SetStyle(CheckboxButtonStyle),			
		Button
		{
			name="dontshow",
			x=70,
			y=155,
			w=600,
			h=30,
			scale = 0.7,
			Text
			{
				font = CheckBoxButtonFont,
				name = "dontshowsave",
				x=0,
				y=0,
				w=500,
				h=40,
				flags = kHAlignLeft + kVAlignCenter,
				label="dontshowsave",
			};
			command=
			function() 
				ToggleSaveInfo();
            end;		
		};
        
    },

} -- MakeDialog
